/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import com.zurrtum.create.client.flywheel.lib.model.baked.BlockMaterialFunction;
import com.zurrtum.create.client.flywheel.lib.model.baked.ByteBufferBuilderStack;
import com.zurrtum.create.client.flywheel.lib.model.baked.MeshEmitter;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_287;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@Environment(value=EnvType.CLIENT)
class MeshEmitterManager<T extends MeshEmitter> {
    private static final class_11515[] CHUNK_LAYERS = class_11515.values();
    private final Reference2ReferenceMap<class_11515, T> emitterMap = new Reference2ReferenceArrayMap();
    private final ByteBufferBuilderStack byteBufferBuilderStack = new ByteBufferBuilderStack();
    private @UnknownNullability BlockMaterialFunction blockMaterialFunction;

    MeshEmitterManager(TriFunction<MeshEmitterManager<T>, ByteBufferBuilderStack, class_11515, T> meshEmitterFactory) {
        for (class_11515 renderType : CHUNK_LAYERS) {
            this.emitterMap.put((Object)renderType, (Object)((MeshEmitter)meshEmitterFactory.apply((Object)this, (Object)this.byteBufferBuilderStack, (Object)renderType)));
        }
    }

    public T getEmitter(class_11515 renderType) {
        return (T)((MeshEmitter)this.emitterMap.get((Object)renderType));
    }

    public void prepare(BlockMaterialFunction blockMaterialFunction) {
        this.blockMaterialFunction = blockMaterialFunction;
        this.byteBufferBuilderStack.reset();
    }

    public void prepareForBlock() {
        for (MeshEmitter emitter : this.emitterMap.values()) {
            emitter.prepareForBlock();
        }
    }

    public SimpleModel end() {
        this.blockMaterialFunction = null;
        ImmutableList.Builder meshes = ImmutableList.builder();
        for (MeshEmitter emitter : this.emitterMap.values()) {
            emitter.end((ImmutableList.Builder<Model.ConfiguredMesh>)meshes);
        }
        return new SimpleModel((List<Model.ConfiguredMesh>)meshes.build());
    }

    @Nullable
    public Material getMaterial(class_11515 renderType, boolean shade, boolean ao) {
        return this.blockMaterialFunction.apply(renderType, shade, ao);
    }

    @Nullable
    public class_287 getBuffer(class_11515 renderType, boolean shade, boolean ao) {
        return ((MeshEmitter)this.emitterMap.get((Object)renderType)).getBuffer(shade, ao);
    }
}

